/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CDevice.h,v 1.4 1999/10/06 06:41:01 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CDevice_h	// [
#define Included_CDevice_h

#include "pgpClassesConfig.h"

#include "CErrorState.h"
#include "CIrp.h"
#include "CUnicodeString.h"

_PGP_BEGIN

// Types

class CDevice;

typedef NTSTATUS (_stdcall *IrpDispatchFunc)(CDevice *, CIrp&, void *refPtr, 
	PGPBoolean&);


// Class CDevice

class CDevice : public CErrorState
{
public:
			CDevice();
	virtual	~CDevice();

	PGPBoolean	IsAttached() const {return mIsAttached;}
	PGPBoolean	WeCreated() const {return mWeCreated;}
	PGPBoolean	WeLinked() const {return mWeLinked;}

	operator PDEVICE_OBJECT() {return mDeviceObject;}
	operator const PDEVICE_OBJECT() const {return mDeviceObject;}

	PDEVICE_OBJECT	Get() const {return mDeviceObject;}

	const CUnicodeString&	DeviceName() const {return mDeviceName;}
	const CUnicodeString&	LinkName() const {return mLinkName;}

	void	UseThisFileObject(PFILE_OBJECT fObj);
	void	UpdateRefPtr(void *refPtr);

	virtual CComboError	Attach(const CUnicodeString& deviceName);
	virtual CComboError	Attach(PDEVICE_OBJECT pDeviceObject);
	virtual void		Detach();

	virtual CComboError	Reference();
	virtual void		Dereference();

	virtual CComboError	Read(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	virtual CComboError	Write(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;

	virtual CComboError	SendIoctlRequest(PGPUInt32 ioctlCode, 
		const void *inBuf = NULL, PGPUInt32 sizeInBuf = 0, 
		void *outBuf = NULL, PGPUInt32 sizeOutBuf = 0, 
		PGPBoolean isInternal = FALSE) const;

	virtual CComboError	SendFsctlRequest(PGPUInt32 minorFunc, 
		PGPUInt32 fsctlCode, const void *inBuf = NULL, 
		PGPUInt32 sizeInBuf = 0, void *outBuf = NULL, 
		PGPUInt32 sizeOutBuf = 0) const;

	virtual CComboError	Create(PDRIVER_OBJECT pDriverObject, 
		const CUnicodeString& deviceName, DEVICE_TYPE deviceType, 
		PGPUInt32 deviceChars, PGPBoolean exclusive, 
		IrpDispatchFunc dispatchFunc, void *refPtr = NULL);
	virtual void		Delete();

	virtual CComboError	Link(const CUnicodeString& deviceName);
	virtual CComboError	Unlink();

	virtual NTSTATUS	CallDriver(CIrp& irp) const;
	virtual NTSTATUS	DispatchIrp(CIrp& irp, PGPBoolean& isIrpCompleted);

protected:
	PGPBoolean	mIsAttached;
	PGPBoolean	mWeCreated;

	PDEVICE_OBJECT	mDeviceObject;
	PFILE_OBJECT	mFileObjectToUse;
	CUnicodeString	mDeviceName;

	PGPBoolean	mWeLinked;
	CUnicodeString	mLinkName;

	IrpDispatchFunc	mDispatchFunc;
	void			*mRefPtr;
};

_PGP_END

#endif	// ] Included_CDevice_h
